<?php
function boc_theme_enqueue_styles() {

    $parent_style = 'boc-main-styles'; // This is 'twentyfifteen-style' for the Twenty Fifteen theme.

    wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'boc-child-styles',
        get_stylesheet_directory_uri() . '/style.css',
        array( $parent_style ),
        wp_get_theme()->get('Version')
    );
}
add_action( 'wp_enqueue_scripts', 'boc_theme_enqueue_styles' );

add_action('wp_enqueue_scripts', 'crunchify_print_scripts_styles');

function crunchify_print_scripts_styles() {
    $result = [];
    $result['scripts'] = [];
    $result['styles'] = [];

    // Print all loaded Scripts
    global $wp_scripts;
    foreach( $wp_scripts->queue as $script ){
		echo "<script>console.log('$script');</script>";
	}
      // $result['scripts'][] =  $wp_scripts->registered[$script]->src . ";";
    //endforeach;

    // Print all loaded Styles (CSS)
    global $wp_styles;
    foreach( $wp_styles->queue as $style ){
		echo "<script>console.log('$style');</script>";
	}
      // $result['styles'][] =  $wp_styles->registered[$style]->src . ";";
    //endforeach;
	return $result;
}
//Dequeue Styles
function project_dequeue_unnecessary_styles() {
//wp_dequeue_style( 'fontawesome' );
//wp_deregister_style( 'fontawesome' );
	wp_dequeue_style( 'easy-social-sharing' );
	//wp_deregister_style( 'easy-social-sharing-general' );
//wp_dequeue_style( 'ultimate-vc-addons-slick-css' );
//wp_deregister_style( 'ultimate-vc-addons-slick-css' );
}
add_action( 'wp_print_styles', 'project_dequeue_unnecessary_styles' );
//Dequeue JavaScripts
function project_dequeue_unnecessary_scripts() {
    wp_dequeue_script( 'fortuna.lib' );
    wp_deregister_script( 'fortuna.lib' );
}
add_action( 'wp_print_scripts', 'project_dequeue_unnecessary_scripts' );

//Remove Gutenberg Block Library CSS from loading on the frontend
function smartwp_remove_wp_block_library_css(){
	 wp_dequeue_style( 'wp-block-library' );
	 wp_dequeue_style( 'wp-block-library-theme' );
	 wp_dequeue_style( 'wc-blocks-style' ); // Remove WooCommerce block CSS
	 wp_dequeue_style( 'storefront-gutenberg-blocks' );
} 
add_action('wp_enqueue_scripts', 'smartwp_remove_wp_block_library_css', 99 );
?>