<?php
/**
 * Plugin Name: Parallax & Video Backgrounds for WPBakery Page Builder
 * Plugin URI: https://parallax.brainstormforce.com/
 * Author: Brainstorm Force
 * Author URI: https://www.brainstormforce.com
 * Version: 1.5.15
 * Description: Includes WPBakery Page Builder row background customization options like Video Background, Vertical Parallax, Horizontal parallax, Interactive Parallax, Gradient backgrounds, Background Styles, Background Overlays, background Scroll animation.
 * Text Domain: upb_parallax
 * License: GPL version 2 or later - http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * @package Parallax & Video Backgrounds for WPBakery Page Builder
 */

// Exit if the file is called directy by URL.
defined( 'ABSPATH' ) || exit;

if ( ! defined( 'VC_PARALLAX_BG_VERSION' ) ) {
	define( 'VC_PARALLAX_BG_VERSION', '1.5.15' );
}

// Refresh bundled products on activate.

register_activation_hook( __FILE__, 'on_updater_activate' );
/**
 * Plugin update file

 * @access public
 */
function on_updater_activate() {
	update_site_option( 'bsf_force_check_extensions', true );
}
define( 'BSF_REMOVE_7320433_FROM_REGISTRATION_LISTING', true );

if ( isset( $_GET['uvc-vc-row-class'], $_GET['uvc-vc-row-class_nonce'] )
	&& wp_verify_nonce( sanitize_key( $_GET['uvc-vc-row-class_nonce'] ), 'uvc-vc-row-class_action' ) ) {
	update_option( 'ultimate_custom_vc_row', sanitize_text_field( wp_unslash( $_GET['uvc-vc-row-class'] ) ) );
}
if ( isset( $_GET['uvc-video-fixer'], $_GET['parallax-video-pnvb-submit-nonce'] )
	&& wp_verify_nonce( sanitize_key( $_GET['parallax-video-pnvb-submit-nonce'] ), 'parallax-video-pnvb-submit' ) && '' != $_GET['uvc-video-fixer'] ) {
	update_option( 'ultimate_video_fixer', sanitize_text_field( wp_unslash( $_GET['uvc-video-fixer'] ) ) );
}
if ( isset( $_GET['uvc-theme-support'], $_GET['parallax-video-pnvb-submit-nonce'] )
	&& wp_verify_nonce( sanitize_key( $_GET['parallax-video-pnvb-submit-nonce'] ), 'parallax-video-pnvb-submit' ) && '' != $_GET['uvc-theme-support'] ) {
	update_option( 'ultimate_theme_support', sanitize_text_field( wp_unslash( $_GET['uvc-theme-support'] ) ) );
}

if ( ! function_exists( 'ultimate_hex2rgb' ) ) {
	/**
	 * Hex to Rgb

	 * @param mixed $hex hex number.
	 * @param mixed $opacity color opacity.
	 * @access public
	 */
	function ultimate_hex2rgb( $hex, $opacity = 1 ) {
		$hex = str_replace( '#', '', $hex );
		if ( strlen( $hex ) == 3 ) {
			$r = hexdec( substr( $hex, 0, 1 ) . substr( $hex, 0, 1 ) );
			$g = hexdec( substr( $hex, 1, 1 ) . substr( $hex, 1, 1 ) );
			$b = hexdec( substr( $hex, 2, 1 ) . substr( $hex, 2, 1 ) );
		} else {
			$r = hexdec( substr( $hex, 0, 2 ) );
			$g = hexdec( substr( $hex, 2, 2 ) );
			$b = hexdec( substr( $hex, 4, 2 ) );
		}
		$rgba = 'rgba(' . $r . ',' . $g . ',' . $b . ',' . $opacity . ')';
		return $rgba;
	}
}
if ( ! class_exists( 'VC_Ultimate_Parallax' ) ) {
	/**
	 * Function that initializes  Ultimate Parallax.
	 *
	 * @class VC_Ultimate_Parallax
	 */
	class VC_Ultimate_Parallax {
		/**
		 * Holds js files.
		 *
		 * @access public
		 * @var $assets_js Class instance.
		 */
		public $assets_js;
		/**
		 * Holds css files.
		 *
		 * @access public
		 * @var $assets_css Class instance.
		 */
		public $assets_css;
		/**
		 * Constructor function that constructs default values for the Ultimate Parallax.
		 *
		 * @method __construct
		 */
		public function __construct() {
			$this->assets_js  = plugins_url( 'assets/js/', __FILE__ );
			$this->assets_css = plugins_url( 'assets/css/', __FILE__ );
			add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
			add_action( 'wp_head', array( $this, 'ultimate_init_vars' ) );
			add_action( 'wp_enqueue_scripts', array( $this, 'front_scripts_global' ) );
			add_action( 'admin_init', array( $this, 'parallax_init' ) );
			add_action( 'admin_menu', array( $this, 'parallax_admin_page' ) );
			// Add popup license form on plugin list page.
			add_action( 'plugin_action_links_' . plugin_basename( __FILE__ ), array( $this, 'v_c_ultimate_parallax_license_form_and_links' ) );
			add_action( 'network_admin_plugin_action_links_' . plugin_basename( __FILE__ ), array( $this, 'v_c_ultimate_parallax_license_form_and_links' ) );
			add_filter( 'parallax_image_video', array( $this, 'parallax_shortcode' ), 10, 3 );
			add_filter( 'bsf_skip_braisntorm_menu', array( $this, 'vc_parallax_bg_skip_brainstorm_menu' ) );
			add_filter( 'bsf_registration_page_url_7320433', array( $this, 'vc_parallax_bg_bsf_registration_page_url' ) );

			if ( defined( 'WPB_VC_VERSION' ) && version_compare( WPB_VC_VERSION, 4.8 ) >= 0 ) {
				if ( function_exists( 'vc_add_shortcode_param' ) ) {
					vc_add_shortcode_param( 'number', array( &$this, 'number_settings_field' ) );
					vc_add_shortcode_param( 'radio_image_box', array( &$this, 'radio_image_settings_field' ) );
					vc_add_shortcode_param( 'gradient', array( &$this, 'gradient_picker' ) );
					vc_add_shortcode_param( 'ult_switch', array( &$this, 'checkbox_param' ) );
					vc_add_shortcode_param( 'ult_param_heading', array( &$this, 'ult_param_heading_callback' ) );
				}
			}

		}//end __construct()

		/**
		 * Show action links on the plugin screen.
		 *
		 * @param   mixed $links Plugin Action links.
		 * @return  array        Filtered plugin action links.
		 */
		public function v_c_ultimate_parallax_license_form_and_links( $links = array() ) {

			if ( function_exists( 'get_bsf_inline_license_form' ) ) {

				$args = array(
					'product_id'              => '7320433',
					'popup_license_form'      => true,
					'bsf_license_allow_email' => true,
				);

				return get_bsf_inline_license_form( $links, $args, 'envato' );
			}

			return $links;
		}
		/**
		 * Product ID.
		 *
		 * @param   mixed $products Plugin product Id.
		 */
		public function vc_parallax_bg_skip_brainstorm_menu( $products ) {

			$products[] = '7320433'; // Brainstorm ID of the product.

			return $products;
		}
		/**
		 * Show registration page url
		 *
		 * @access public
		 */
		public function vc_parallax_bg_bsf_registration_page_url() {
			if ( is_multisite() ) {
				return network_admin_url( 'plugins.php?bsf-inline-license-form=7320433' );
			} else {
				return admin_url( 'plugins.php?bsf-inline-license-form=7320433' );
			}
		}
		/**
		 * Admin page.
		 *
		 * @access public
		 */
		public function parallax_admin_page() {
			add_submenu_page( 'options-general.php', 'bsf-vc-backgrounds-settings', 'Parallax & Video Backgrounds', 'manage_options', 'bsf-vc-backgrounds-settings', array( $this, 'admin_page_callback' ) );
		}
		/**
		 * Admin page callback.
		 *
		 * @access public
		 */
		public function admin_page_callback() {
			include_once 'admin/dashboard.php';
		}
		/**
		 * Init vars.
		 *
		 * @access public
		 */
		public function ultimate_init_vars() {
			$ultimate_smooth_scroll_options = get_option( 'ultimate_smooth_scroll_options' );
			$step                           = ( isset( $ultimate_smooth_scroll_options['step'] ) && '' != $ultimate_smooth_scroll_options['step'] ) ? $ultimate_smooth_scroll_options['step'] : 45;
			$speed                          = ( isset( $ultimate_smooth_scroll_options['speed'] ) && '' != $ultimate_smooth_scroll_options['step'] ) ? $ultimate_smooth_scroll_options['speed'] : 250;
			echo "<script type='text/javascript'>
				jQuery(document).ready(function($) {
				var ult_smooth_speed = " . esc_js( $speed ) . ';
				var ult_smooth_step = ' . esc_js( $step ) . ";
				$('html').attr('data-ult_smooth_speed',ult_smooth_speed).attr('data-ult_smooth_step',ult_smooth_step);
				});
			</script>";
		}
		/**
		 * Global scrips.
		 *
		 * @access public
		 */
		public function front_scripts_global() {
			$ultimate_smooth_scroll = get_option( 'ultimate_smooth_scroll' );
			if ( 'enable' == $ultimate_smooth_scroll ) {
				$ultimate_smooth_scroll_compatible = get_option( 'ultimate_smooth_scroll_compatible' );
				if ( 'enable' === $ultimate_smooth_scroll_compatible ) {
					$smooth_scroll = 'SmoothScroll-compatible.min.js';
				} else {
					$smooth_scroll = 'SmoothScroll.min.js';
				}
				wp_register_script( 'ultimate-smooth-scroll', plugins_url( 'assets/js/' . $smooth_scroll, __FILE__ ), array( 'jquery' ), VC_PARALLAX_BG_VERSION, true );
				wp_enqueue_script( 'ultimate-smooth-scroll' );
			}
		}
		/**
		 * Callbacks.
		 *
		 * @param mixed $settings settings.
		 * @param mixed $value value.
		 * @access public
		 */
		public function ult_param_heading_callback( $settings, $value ) {
			$dependency = '';
			$param_name = isset( $settings['param_name'] ) ? $settings['param_name'] : '';
			$class      = isset( $settings['class'] ) ? $settings['class'] : '';
			$text       = isset( $settings['text'] ) ? $settings['text'] : '';
			$output     = '<h4 ' . $dependency . ' class="wpb_vc_param_value ' . esc_attr( $class ) . '">' . esc_html( $text ) . '</h4>';
			return $output;
		}
		/**
		 * Ult_switch param.
		 *
		 * @param mixed $settings settings.
		 * @param mixed $value value.
		 * @access public
		 */
		public function checkbox_param( $settings, $value ) {
			$dependency = '';
			$param_name = isset( $settings['param_name'] ) ? $settings['param_name'] : '';
			$type       = isset( $settings['type'] ) ? $settings['type'] : '';
			$options    = isset( $settings['options'] ) ? $settings['options'] : '';
			$class      = isset( $settings['class'] ) ? $settings['class'] : '';
			$output     = '';
			$checked    = '';
			$un         = uniqid( 'ultswitch-' . wp_rand() );
			if ( is_array( $options ) && ! empty( $options ) ) {
				foreach ( $options as $key => $opts ) {
					if ( $value == $key ) {
						$checked = 'checked';
					} else {
						$checked = '';
					}
					$uid     = uniqid( 'ultswitchparam-' . wp_rand() );
					$output .= '<div class="onoffswitch">
							<input type="checkbox" name="' . esc_attr( $param_name ) . '" value="' . esc_attr( $value ) . '" ' . esc_attr( $dependency ) . ' class="wpb_vc_param_value ' . esc_attr( $param_name ) . ' ' . esc_attr( $type ) . ' ' . esc_attr( $class ) . ' ' . esc_attr( $dependency ) . ' onoffswitch-checkbox chk-switch-' . $un . '" id="switch' . $uid . '" ' . $checked . '>
							<label class="onoffswitch-label" for="switch' . esc_attr( $uid ) . '">
								<div class="onoffswitch-inner">
									<div class="onoffswitch-active">
										<div class="onoffswitch-switch">' . esc_html( $opts['on'] ) . '</div>
									</div>
									<div class="onoffswitch-inactive">
										<div class="onoffswitch-switch">' . esc_html( $opts['off'] ) . '</div>
									</div>
								</div>
							</label>
						</div>';
					if ( isset( $opts['label'] ) ) {
						$lbl = $opts['label'];
					} else {
						$lbl = '';
					}
					$output .= '<div class="chk-label">' . esc_html( $lbl ) . '</div><br/>';
				}
			}

			$output .= '<script type="text/javascript">
				jQuery("#switch' . esc_js( $uid ) . '").change(function(){

					 if(jQuery("#switch' . esc_js( $uid ) . '").is(":checked")){
						jQuery("#switch' . esc_js( $uid ) . '").val("' . esc_js( $key ) . '");
						jQuery("#switch' . esc_js( $uid ) . '").attr("checked","checked");
					 } else {
						jQuery("#switch' . esc_js( $uid ) . '").val("off");
						jQuery("#switch' . esc_js( $uid ) . '").removeAttr("checked");
					 }

				});
			</script>';

			return $output;
		}
		/**
		 * Ult_switch param.
		 *
		 * @param mixed $settings settings.
		 * @param mixed $value value.
		 * @access public
		 */
		public function gradient_picker( $settings, $value ) {
			$dependency = '';
			$param_name = isset( $settings['param_name'] ) ? $settings['param_name'] : '';
			$type       = isset( $settings['type'] ) ? $settings['type'] : '';
			$color1     = isset( $settings['color1'] ) ? $settings['color1'] : ' ';
			$color2     = isset( $settings['color2'] ) ? $settings['color2'] : ' ';
			$class      = isset( $settings['class'] ) ? $settings['class'] : '';

			$dependency_element    = $settings['dependency']['element'];
			$dependency_value      = $settings['dependency']['value'];
			$dependency_value_json = wp_json_encode( $dependency_value );

			$uni    = uniqid();
			$output = '<div class="vc_ug_control" data-uniqid="' . esc_attr( $uni ) . '" data-color1="' . esc_attr( $color1 ) . '" data-color2="' . esc_attr( $color2 ) . '">';

			$output .= '<select id="grad_type' . esc_attr( $uni ) . '" class="grad_type" data-uniqid="' . esc_attr( $uni ) . '">
				<option value="vertical">' . __( 'Vertical', 'upb_parallax' ) . '</option>
				<option value="horizontal">' . __( 'Horizontal', 'upb_parallax' ) . '</option>
				<option value="custom">' . __( 'Custom', 'upb_parallax' ) . '</option>
			</select>
			<div id="grad_type_custom_wrapper' . esc_attr( $uni ) . '" class="grad_type_custom_wrapper" style="display:none;"><input type="number" id="grad_type_custom' . esc_attr( $uni ) . '" placeholder="45" data-uniqid="' . esc_attr( $uni ) . '" class="grad_custom" style="width: 200px; margin-bottom: 10px;"/> deg</div>';
			$output .= '<div class="wpb_element_label" style="margin-top: 10px;">' . __( 'Choose Colors', 'upb_parallax' ) . '</div>';
			$output .= '<div class="grad_hold" id="grad_hold' . esc_attr( $uni ) . '"></div>';
			$output .= '<div class="grad_trgt" id="grad_target' . esc_attr( $uni ) . '"></div>';

			$output .= '<input id="grad_val' . esc_attr( $uni ) . '" class="wpb_vc_param_value ' . esc_attr( $param_name ) . ' ' . esc_attr( $type ) . ' ' . esc_attr( $class ) . ' vc_ug_gradient" name="' . esc_attr( $param_name ) . '"  style="display:none"  value="' . esc_attr( $value ) . '" ' . esc_attr( $dependency ) . '/></div>';

			?>
				<script type="text/javascript">
				jQuery(document).ready(function(){
						var dependency_element = '<?php echo esc_js( $dependency_element ); ?>';
						var dependency_values = jQuery.parseJSON('<?php echo $dependency_value_json; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>');
						var dependency_values_array = jQuery.map(dependency_values, function(el) { return el; });

						var get_depend_value = jQuery('.'+dependency_element).val();

						jQuery('.grad_type').change(function(){
							var uni = jQuery(this).data('uniqid');
							var hid = "#grad_hold"+uni;
							var did = "#grad_target"+uni;
							var cid = "#grad_type_custom"+uni;
							var tid = "#grad_val"+uni;
							var cid_wrapper = "#grad_type_custom_wrapper"+uni;
							var orientation = jQuery(this).children('option:selected').val();

							if(orientation == 'custom')
							{
								jQuery(cid_wrapper).show();
							}
							else
							{
								jQuery(cid_wrapper).hide();
								if(orientation == 'vertical')
									var ori = 'top';
								else
									var ori = 'left';

								jQuery(hid).data('ClassyGradient').setOrientation(ori);
								var newCSS = jQuery(hid).data('ClassyGradient').getCSS();

								jQuery(tid).val(newCSS);
							}

						});

						jQuery('.grad_custom').on('keyup',function() {
							var uni = jQuery(this).data('uniqid');
							var hid = "#grad_hold"+uni;
							var gid = "#grad_type"+uni;
							var tid = "#grad_val"+uni;
							var orientation = jQuery(this).val()+'deg';
							jQuery(hid).data('ClassyGradient').setOrientation(orientation);
							var newCSS = jQuery(hid).data('ClassyGradient').getCSS();
							jQuery(tid).val(newCSS);
						});

						function gradient_pre_defined(dependency_element, dependency_values_array){
							jQuery('.vc_ug_control').each(function(){
								var uni = jQuery(this).data('uniqid');
								var hid = "#grad_hold"+uni;
								var did = "#grad_target"+uni;
								var tid = "#grad_val"+uni;
								var oid = "#grad_type"+uni;
								var cid = "#grad_type_custom"+uni;
								var cid_wrapper = "#grad_type_custom_wrapper"+uni;
								var orientation = jQuery(oid).children('option:selected').val();
								var prev_col = jQuery(tid).val();

								var is_custom = 'false';

								if(prev_col!='')
								{
									if(prev_col.indexOf('-webkit-linear-gradient(top,') != -1)
									{
										var p_l = prev_col.indexOf('-webkit-linear-gradient(top,');
										prev_col = prev_col.substring(p_l+28);
										p_l = prev_col.indexOf(');');
										prev_col = prev_col.substring(0,p_l);
										orientation = 'vertical';
									}
									else if(prev_col.indexOf('-webkit-linear-gradient(left,') != -1)
									{
										var p_l = prev_col.indexOf('-webkit-linear-gradient(left,');
										prev_col = prev_col.substring(p_l+29);
										p_l = prev_col.indexOf(');');
										prev_col = prev_col.substring(0,p_l);
										orientation = 'horizontal';
									}
									else
									{
										var p_l = prev_col.indexOf('-webkit-linear-gradient(');

										var subStr = prev_col.match("-webkit-linear-gradient((.*));background: -o");

										var prev_col = subStr[1].replace(/\(|\)/g, '');

										var temp_col = prev_col;

										var t_l = temp_col.indexOf('deg');
										var deg = temp_col.substring(0,t_l);

										prev_col = prev_col.substring(t_l+4, prev_col.length);

										jQuery(cid).val(deg);
										jQuery(cid_wrapper).show();
										orientation = 'custom';
										is_custom = 'true';
									}
								}
								else
								{
									prev_col ="#e3e3e3 0%";
								}

								jQuery(oid).children('option').each(function(i,opt){
									if(opt.value == orientation)
										jQuery(this).attr('selected',true);

								});

								if(is_custom == 'true')
									orientation = deg+'deg';
								else
								{
									if(orientation == 'vertical')
										orientation = 'top';
									else
										orientation = 'left';
								}

								jQuery(hid).ClassyGradient({
									width:350,
									height:25,
									orientation : orientation,
									target:did,
									gradient: prev_col,
									onChange: function(stringGradient,cssGradient) {

										var depend = uvc_gradient_verfiy_depedant(dependency_element, dependency_values_array);

										cssGradient = cssGradient.replace('url(data:image/svg+xml;base64,','');
										var e_pos = cssGradient.indexOf(';');
										cssGradient = cssGradient.substring(e_pos+1);
										if(jQuery(tid).parents('.wpb_el_type_gradient').css('display')=='none'){
											cssGradient='';
										}
										if(depend)
											jQuery(tid).val(cssGradient);
										else
											jQuery(tid).val('');
									},
									onInit: function(cssGradient){
									}
								});
								jQuery('.colorpicker').css('z-index','999999');
							})
						}
						if(jQuery.inArray( get_depend_value, dependency_values_array ) !== -1)
							var depend = true;
						else
							var depend = false;
						gradient_pre_defined(dependency_element, dependency_values_array);

						jQuery('.'+dependency_element).on('change',function(){
							var depend = uvc_gradient_verfiy_depedant(dependency_element, dependency_values_array);
							jQuery('.vc_ug_control').each(function(){
								var uni = jQuery(this).data('uniqid');
								var tid = "#grad_val"+uni;
								if(depend === false)
									jQuery(tid).val('');
								else
									gradient_pre_defined(dependency_element, dependency_values_array);
							});

						});

						function uvc_gradient_verfiy_depedant(dependency_element, dependency_values_array) {
							var get_depend_value = jQuery('.'+dependency_element).val();
							if(jQuery.inArray( get_depend_value, dependency_values_array ) !== -1)
								return true;
							else
								return false;
						}

				})
				</script>
			<?php
			return $output;
		}
		/**
		 * Execute shortcode.
		 *
		 * @param mixed $settings settings.
		 * @param mixed $value value.
		 * @access public
		 */
		public function number_settings_field( $settings, $value ) {
			$dependency = '';
			$param_name = isset( $settings['param_name'] ) ? $settings['param_name'] : '';
			$type       = isset( $settings['type'] ) ? $settings['type'] : '';
			$min        = isset( $settings['min'] ) ? $settings['min'] : '';
			$max        = isset( $settings['max'] ) ? $settings['max'] : '';
			$suffix     = isset( $settings['suffix'] ) ? $settings['suffix'] : '';
			$class      = isset( $settings['class'] ) ? $settings['class'] : '';
			$output     = '<input type="number" min="' . esc_attr( $min ) . '" max="' . esc_attr( $max ) . '" class="wpb_vc_param_value ' . esc_attr( $param_name ) . ' ' . esc_attr( $type ) . ' ' . esc_attr( $class ) . '" name="' . esc_attr( $param_name ) . '" value="' . esc_attr( $value ) . '" style="max-width:100px; margin-right: 10px;" />' . $suffix;
			return $output;
		}
		/**
		 * Execute shortcode.
		 *
		 * @param mixed $hook settings.
		 * @access public
		 */
		public function admin_scripts( $hook ) {
			if ( 'post.php' == $hook || 'post-new.php' == $hook ) {
				wp_enqueue_script( 'jquery.colorpicker', $this->assets_js . 'jquery.colorpicker.js', array( 'jquery' ), VC_PARALLAX_BG_VERSION, true );
				wp_enqueue_script( 'jquery.classygradient', $this->assets_js . 'jquery.classygradient.min.js', array( 'jquery' ), VC_PARALLAX_BG_VERSION, true );
				wp_enqueue_style( 'colorpicker.style', $this->assets_css . 'jquery.colorpicker.css', VC_PARALLAX_BG_VERSION, true );
				wp_enqueue_style( 'classygradient.style', $this->assets_css . 'jquery.classygradient.min.css', VC_PARALLAX_BG_VERSION, true );
				wp_enqueue_style( 'vc-ultimate-parallax-admin', $this->assets_css . 'icon-manager.css', VC_PARALLAX_BG_VERSION, true );
			}
		}//end admin_scripts()
		/**
		 * Font Scripts
		 *
		 * @access public
		 */
		public function front_scripts() {
			wp_enqueue_script( 'jquery.video_bg', $this->assets_js . 'ultimate_bg.js', array( 'jquery' ), VC_PARALLAX_BG_VERSION, true );
			wp_enqueue_script( 'jquery.shake', $this->assets_js . 'jparallax.js', array( 'jquery', 'jquery.video_bg' ), VC_PARALLAX_BG_VERSION, true );
			wp_enqueue_script( 'jquery.vhparallax', $this->assets_js . 'jquery.vhparallax.js', array( 'jquery', 'jquery.video_bg' ), VC_PARALLAX_BG_VERSION, true );
			wp_enqueue_style( 'background-style', $this->assets_css . 'background-style.css', VC_PARALLAX_BG_VERSION, true );

			wp_enqueue_script( 'ultimate-appear', $this->assets_js . 'jquery.appear.js', 'jquery', VC_PARALLAX_BG_VERSION, true );
			wp_enqueue_script( 'ultimate-custom', $this->assets_js . 'custom.js', array( 'jquery', 'jquery.video_bg' ), VC_PARALLAX_BG_VERSION, true );
			// register css.
			wp_enqueue_style( 'ultimate-animate', $this->assets_css . 'animate.css', VC_PARALLAX_BG_VERSION, true );
			wp_enqueue_style( 'ultimate-style', $this->assets_css . 'style.css', VC_PARALLAX_BG_VERSION, true );
		} // end front_scripts.
		/**
		 * Execute shortcode.
		 *
		 * @param mixed $output output.
		 * @param mixed $atts atts.
		 * @param mixed $content cotent.
		 * @access public
		 */
		public function parallax_shortcode( $output, $atts, $content ) {
			$html                   = '';
			$bsf_img_repeat         = '';
			$css                    = '';
			$overlay                = '';
			$seperator_html         = '';
			$seperator_bottom_html  = '';
			$seperator_top_html     = '';
			$seperator_css          = '';
			$commom_data_attributes = '';
			$autoplay               = '';
			$muted                  = '';
			$loop                   = '';
			$vc_version             = '';

				$pax_settings = shortcode_atts(
					array(
						'bg_type'                        => 'no_bg',
						'bg_image'                       => '',
						'bg_image_new'                   => '',
						'bg_image_repeat'                => 'repeat',
						'bg_image_size'                  => 'cover',
						'parallax_style'                 => 'vcpb-default',
						'parallax_sense'                 => '30',
						'video_opts'                     => '',
						'bg_image_posiiton'              => '',
						'video_url'                      => '',
						'video_url_2'                    => '',
						'video_poster'                   => '',
						'u_video_url'                    => '',
						'bg_cstm_size'                   => '',
						'bg_override'                    => '0',
						'bg_img_attach'                  => 'scroll',
						'u_start_time'                   => '',
						'u_stop_time'                    => '',
						'layer_image'                    => '',
						'bg_grad'                        => '',
						'bg_color_value'                 => '',
						'bg_fade'                        => '',
						'css'                            => '',
						'viewport_vdo'                   => '',
						'enable_controls'                => '',
						'controls_color'                 => '',
						'animation_direction'            => 'left-animation',
						'animation_type'                 => 'false',
						'horizontal_animation'           => '',
						'vertical_animation'             => '',
						'animation_speed'                => '',
						'animation_repeat'               => 'repeat',
						'animated_bg_color'              => '',
						'fadeout_row'                    => '',
						'fadeout_start_effect'           => '30',
						'parallax_content'               => '',
						'parallax_content_sense'         => '30',
						'disable_on_mobile'              => '',
						'disable_on_mobile_img_parallax' => 'off',
						'enable_overlay'                 => '',
						'overlay_color'                  => '',
						'overlay_pattern'                => '',
						'overlay_pattern_opacity'        => '80',
						'overlay_pattern_size'           => '',
						'overlay_pattern_attachment'     => 'fixed',
						'multi_color_overlay'            => '',
						'multi_color_overlay_opacity'    => '60',
						'seperator_enable'               => '',
						'seperator_type'                 => 'none_seperator',
						'seperator_position'             => 'top_seperator',
						'seperator_shape_size'           => '40',
						'seperator_shape_background'     => '#fff',
						'seperator_shape_border'         => 'none',
						'seperator_shape_border_color'   => '',
						'seperator_shape_border_width'   => '1',
						'seperator_svg_height'           => '60',
						'ult_hide_row'                   => '',
						'ult_hide_row_large_screen'      => '',
						'ult_hide_row_desktop'           => '',
						'ult_hide_row_tablet'            => '',
						'ult_hide_row_tablet_small'      => '',
						'ult_hide_row_mobile'            => '',
						'ult_hide_row_mobile_large'      => '',
						'video_fixer'                    => 'true',
					),
					$atts
				);

			if ( defined( 'WPB_VC_VERSION' ) ) {
					$vc_version = WPB_VC_VERSION;
			}

			$ultimate_custom_vc_row = get_option( 'ultimate_custom_vc_row' );
			$ultimate_theme_support = get_option( 'ultimate_theme_support' );

			$is_vc_4_4 = ( version_compare( $vc_version, '4.4', '<' ) ) ? true : false;

			$commom_data_attributes .= ' data-custom-vc-row="' . esc_attr( $ultimate_custom_vc_row ) . '" ';
			$commom_data_attributes .= ' data-vc="' . esc_attr( $vc_version ) . '" ';
			$commom_data_attributes .= ' data-is_old_vc="' . esc_attr( $is_vc_4_4 ) . '" ';
			$commom_data_attributes .= ' data-theme-support="' . esc_attr( $ultimate_theme_support ) . '" ';

			$pax_settings['disable_on_mobile'] = 'true';

			if ( 'off' == $pax_settings['disable_on_mobile_img_parallax'] || '' == $pax_settings['disable_on_mobile_img_parallax'] ) {
				$pax_settings['disable_on_mobile_img_parallax'] = 'true';
			} else {
				$pax_settings['disable_on_mobile_img_parallax'] = 'false';
			}

				// for overlay.
			if ( 'enable_overlay_value' == $pax_settings['enable_overlay'] ) {
				if ( 'transperant' != $pax_settings['overlay_pattern'] && '' != $pax_settings['overlay_pattern'] ) {
					$pattern_url = plugins_url( 'assets/images/patterns/', __FILE__ ) . $pax_settings['overlay_pattern'];
				} else {
					$pattern_url = '';
				}
				if ( preg_match( '/^#[a-f0-9]{6}$/i', $pax_settings['overlay_color'] ) ) { // hex color is valid.
					$pax_settings['overlay_color'] = hex2rgb_ult_parallax( $pax_settings['overlay_color'], $opacity = 0.2 );
				}

				if ( strpos( $pax_settings['overlay_pattern_opacity'], '.' ) === false ) {
					$pax_settings['overlay_pattern_opacity'] = $pax_settings['overlay_pattern_opacity'] / 100;
				}

				$overlay = ' data-overlay="true" data-overlay-color="' . esc_attr( $pax_settings['overlay_color'] ) . '" data-overlay-pattern="' . esc_attr( $pattern_url ) . '" data-overlay-pattern-opacity="' . esc_attr( $pax_settings['overlay_pattern_opacity'] ) . '" data-overlay-pattern-size="' . esc_attr( $pax_settings['overlay_pattern_size'] ) . '" data-overlay-pattern-attachment="' . esc_attr( $pax_settings['overlay_pattern_attachment'] ) . '" ';

				if ( 'uvc-multi-color-bg' == $pax_settings['multi_color_overlay'] ) {
					$pax_settings['multi_color_overlay_opacity'] = $pax_settings['multi_color_overlay_opacity'] / 100;
					$overlay                                    .= ' data-multi-color-overlay="' . esc_attr( $pax_settings['multi_color_overlay'] ) . '" data-multi-color-overlay-opacity="' . esc_attr( $pax_settings['multi_color_overlay_opacity'] ) . '" ';
				}
			} else {
				$overlay = ' data-overlay="false" data-overlay-color="" data-overlay-pattern="" data-overlay-pattern-opacity="" data-overlay-pattern-size="" ';
			}

				// for seperator.
			if ( 'seperator_enable_value' == $pax_settings['seperator_enable'] ) {
				$seperator_bottom_html  = ' data-seperator="true" ';
				$seperator_bottom_html .= ' data-seperator-type="' . esc_attr( $pax_settings['seperator_type'] ) . '" ';
				$seperator_bottom_html .= ' data-seperator-shape-size="' . esc_attr( $pax_settings['seperator_shape_size'] ) . '" ';
				$seperator_bottom_html .= ' data-seperator-svg-height="' . esc_attr( $pax_settings['seperator_svg_height'] ) . '" ';
				$seperator_bottom_html .= ' data-seperator-full-width="true"';
				$seperator_bottom_html .= ' data-seperator-position="' . esc_attr( $pax_settings['seperator_position'] ) . '" ';

				if ( '' != $pax_settings['seperator_shape_background'] ) {
					if ( 'multi_triangle_seperator' == $pax_settings['seperator_type'] ) {
						preg_match( '/\(([^)]+)\)/', $pax_settings['seperator_shape_background'], $output_temp );
						if ( isset( $output_temp[1] ) ) {
							$rgba                                       = explode( ',', $output_temp[1] );
							$pax_settings['seperator_shape_background'] = rgba_to_hex_ultimate( $rgba[0], $rgba[1], $rgba[2] );
						}
					}
					$seperator_bottom_html .= ' data-seperator-background-color="' . esc_attr( $pax_settings['seperator_shape_background'] ) . '" ';
				}
				if ( 'none' != $pax_settings['seperator_shape_border'] ) {
					$seperator_bottom_html .= ' data-seperator-border="' . esc_attr( $pax_settings['seperator_shape_border'] ) . '" ';
					$bwidth                 = ( '' == $pax_settings['seperator_shape_border_width'] ) ? '1' : $pax_settings['seperator_shape_border_width'];
					$seperator_bottom_html .= ' data-seperator-border-width="' . esc_attr( $bwidth ) . '" ';
					$seperator_bottom_html .= ' data-seperator-border-color="' . esc_attr( $pax_settings['seperator_shape_border_color'] ) . '" ';
				}
			}

				$seperator_html = $seperator_top_html . ' ' . $seperator_bottom_html;

				// for hide row.
				$device_message    = '';
				$ult_hide_row_data = '';
			if ( 'ult_hide_row_value' == $pax_settings['ult_hide_row'] ) {
				if ( 'large_screen' == $pax_settings['ult_hide_row_large_screen'] ) {
					$ult_hide_row_data .= ' uvc_hidden-lg ';
				}
				if ( 'desktop' == $pax_settings['ult_hide_row_desktop'] ) {
					$ult_hide_row_data .= ' uvc_hidden-ml ';
				}
				if ( 'tablet' == $pax_settings['ult_hide_row_tablet'] ) {
					$ult_hide_row_data .= ' uvc_hidden-md ';
				}
				if ( 'xs_tablet' == $pax_settings['ult_hide_row_tablet_small'] ) {
					$ult_hide_row_data .= ' uvc_hidden-sm ';
				}
				if ( 'mobile' == $pax_settings['ult_hide_row_mobile'] ) {
					$ult_hide_row_data .= ' uvc_hidden-xs ';
				}
				if ( 'xl_mobile' == $pax_settings['ult_hide_row_mobile_large'] ) {
					$ult_hide_row_data .= ' uvc_hidden-xsl ';
				}

				if ( '' != $ult_hide_row_data ) {
					$ult_hide_row_data = ' data-hide-row="' . esc_attr( $ult_hide_row_data ) . '" ';
				}
			}

				// RTL.
				$rtl = 'false';
			if ( is_rtl() ) {
				$rtl = 'true';
			}
			if ( 'false' === $rtl || false === $rtl ) {
				$ultimate_rtl_support = get_option( 'ultimate_rtl_support' );
				if ( 'enable' == $ultimate_rtl_support ) {
					$rtl = 'true';
				}
			}

				$output    = '';
				$bg_img_id = false;
			if ( '' != $pax_settings['bg_image_new'] ) {
				$bg_img_id = $pax_settings['bg_image_new'];
			} elseif ( '' != $pax_settings['bg_image'] ) {
				$bg_img_id = $pax_settings['bg_image'];
			} else {
				if ( '' !== $pax_settings['css'] ) {
					$arr = explode( '?id=', $pax_settings['css'] );
					if ( isset( $arr[1] ) ) {
						$arr       = explode( ')', $arr[1] );
						$bg_img_id = $arr[0];
					}
				}
			}
			if ( '' != $pax_settings['bg_image_posiiton'] ) {
				if ( strpos( $pax_settings['bg_image_posiiton'], 'px' ) ) {
					$pos_suffix = 'px';
				} elseif ( strpos( $pax_settings['bg_image_posiiton'], 'em' ) ) {
					$pos_suffix = 'em';
				} else {
					$pos_suffix = '%';
				}
			}
			if ( 'no_bg' == $pax_settings['bg_type'] ) { // @codingStandardsIgnoreLine.
			} elseif ( 'image' == $pax_settings['bg_type'] ) {
				if ( 'cstm' == $pax_settings['bg_image_size'] ) {
					if ( '' != $pax_settings['bg_cstm_size'] ) {
						$pax_settings['bg_image_size'] = $pax_settings['bg_cstm_size'];
					}
				}
				if ( 'vcpb-fs-jquery' == $pax_settings['parallax_style'] || 'vcpb-mlvp-jquery' == $pax_settings['parallax_style'] ) {
					if ( 'vcpb-fs-jquery' == $pax_settings['parallax_style'] ) {
						wp_enqueue_script( 'jquery.shake', $this->assets_js . 'jparallax.js', array( 'jquery', 'jquery.video_bg' ), VC_PARALLAX_BG_VERSION, true );
					}

					if ( 'vcpb-mlvp-jquery' == $pax_settings['parallax_style'] ) {
						wp_enqueue_script( 'jquery.vhparallax', $this->assets_js . 'jquery.vhparallax.js', array( 'jquery', 'jquery.video_bg' ), VC_PARALLAX_BG_VERSION, true );
					}
					$imgs                        = explode( ',', $pax_settings['layer_image'] );
					$pax_settings['layer_image'] = array();
					foreach ( $imgs as $value ) {
						$pax_settings['layer_image'][] = wp_get_attachment_image_src( $value, 'full' );
					}
					foreach ( $pax_settings['layer_image'] as $key => $value ) {
						$bg_imgs[] = $pax_settings['layer_image'][ $key ][0];
					}
					$html .= '<div class="upb_bg_img" data-ultimate-bg="' . implode( ',', $bg_imgs ) . '" data-ultimate-bg-style="' . esc_attr( $pax_settings['parallax_style'] ) . '" data-bg-img-repeat="' . esc_attr( $pax_settings['bg_image_repeat'] ) . '" data-bg-img-size="' . esc_attr( $pax_settings['bg_image_size'] ) . '" data-bg-img-position="' . esc_attr( $pax_settings['bg_image_posiiton'] ) . '" data-parallx_sense="' . esc_attr( $pax_settings['parallax_sense'] ) . '" data-bg-override="' . esc_attr( $pax_settings['bg_override'] ) . '" data-bg_img_attach="' . esc_attr( $pax_settings['bg_img_attach'] ) . '" data-upb-overlay-color="' . esc_attr( $pax_settings['overlay_color'] ) . '" data-upb-bg-animation="' . esc_attr( $pax_settings['bg_fade'] ) . '" data-fadeout="' . esc_attr( $pax_settings['fadeout_row'] ) . '" data-fadeout-percentage="' . esc_attr( $pax_settings['fadeout_start_effect'] ) . '" data-parallax-content="' . esc_attr( $pax_settings['parallax_content'] ) . '" data-parallax-content-sense="' . esc_attr( $pax_settings['parallax_content_sense'] ) . '" data-row-effect-mobile-disable="' . esc_attr( $pax_settings['disable_on_mobile'] ) . '" data-img-parallax-mobile-disable="' . esc_attr( $pax_settings['disable_on_mobile_img_parallax'] ) . '" data-rtl="' . esc_attr( $rtl ) . '" ' . $commom_data_attributes . ' ' . $overlay . ' ' . $seperator_html . ' ' . $ult_hide_row_data . '></div>';
				} else {
					if ( 'vcpb-vz-jquery' == $pax_settings['parallax_style'] || 'vcpb-hz-jquery' == $pax_settings['parallax_style'] ) {
						wp_enqueue_script( 'jquery.vhparallax', $this->assets_js . 'jquery.vhparallax.js', array( 'jquery', 'jquery.video_bg' ), VC_PARALLAX_BG_VERSION, true );
					}

					if ( $bg_img_id ) {
						if ( '' == $pax_settings['animation_direction'] && 'false' != $pax_settings['animation_type'] ) {
							if ( 'h' == $pax_settings['animation_type'] ) {
								$animation = $pax_settings['horizontal_animation'];
							} else {
								$animation = $pax_settings['vertical_animation'];
							}
						} else {
							if ( 'top-animation' == $pax_settings['animation_direction'] || 'bottom-animation' == $pax_settings['animation_direction'] ) {
								$pax_settings['animation_type'] = 'v';
							} else {
								$pax_settings['animation_type'] = 'h';
							}
								$animation = $pax_settings['animation_direction'];
							if ( '' == $animation ) {
								$animation = 'left-animation';
							}
						}

						$bg_img = apply_filters( 'ult_get_img_single', $bg_img_id, 'url' );
						$html  .= '<div class="upb_bg_img" data-ultimate-bg="url(' . esc_url( $bg_img ) . ')" data-image-id="' . esc_attr( $bg_img_id ) . '" data-ultimate-bg-style="' . esc_attr( $pax_settings['parallax_style'] ) . '" data-bg-img-repeat="' . esc_attr( $pax_settings['bg_image_repeat'] ) . '" data-bg-img-size="' . esc_attr( $pax_settings['bg_image_size'] ) . '" data-bg-img-position="' . esc_attr( $pax_settings['bg_image_posiiton'] ) . '" data-parallx_sense="' . esc_attr( $pax_settings['parallax_sense'] ) . '" data-bg-override="' . esc_attr( $pax_settings['bg_override'] ) . '" data-bg_img_attach="' . esc_attr( $pax_settings['bg_img_attach'] ) . '" data-upb-overlay-color="' . esc_attr( $pax_settings['overlay_color'] ) . '" data-upb-bg-animation="' . esc_attr( $pax_settings['bg_fade'] ) . '" data-fadeout="' . esc_attr( $pax_settings['fadeout_row'] ) . '" data-bg-animation="' . esc_attr( $animation ) . '" data-bg-animation-type="' . esc_attr( $pax_settings['animation_type'] ) . '" data-animation-repeat="' . esc_attr( $pax_settings['animation_repeat'] ) . '" data-fadeout-percentage="' . esc_attr( $pax_settings['fadeout_start_effect'] ) . '" data-parallax-content="' . esc_attr( $pax_settings['parallax_content'] ) . '" data-parallax-content-sense="' . esc_attr( $pax_settings['parallax_content_sense'] ) . '" data-row-effect-mobile-disable="' . esc_attr( $pax_settings['disable_on_mobile'] ) . '" data-img-parallax-mobile-disable="' . esc_attr( $pax_settings['disable_on_mobile_img_parallax'] ) . '" data-rtl="' . esc_attr( $rtl ) . '" ' . $commom_data_attributes . ' ' . $overlay . ' ' . $seperator_html . ' ' . $ult_hide_row_data . '></div>';
					}
				}
			} elseif ( 'video' == $pax_settings['bg_type'] ) {
				$v_opts = explode( ',', $pax_settings['video_opts'] );
				if ( is_array( $v_opts ) ) {
					foreach ( $v_opts as $opt ) {
						if ( 'muted' == $opt ) {
							$muted .= $opt;
						}
						if ( 'autoplay' == $opt ) {
							$autoplay .= $opt;
						}
						if ( 'loop' == $opt ) {
							$loop .= $opt;
						}
					}
				}
				if ( 'viewport_play' == $pax_settings['viewport_vdo'] ) {
					$enable_viewport_vdo = 'true';
				} else {
					$enable_viewport_vdo = 'false';
				}

				$video_fixer_option = get_option( 'ultimate_video_fixer' );
				if ( $video_fixer_option ) {
					if ( 'enable' == $video_fixer_option ) {
						$pax_settings['video_fixer'] = 'false';
					}
				}

				$pax_settings['u_stop_time']  = ( '' != $pax_settings['u_stop_time'] ) ? $pax_settings['u_stop_time'] : 0;
				$pax_settings['u_start_time'] = ( '' != $pax_settings['u_stop_time'] ) ? $pax_settings['u_start_time'] : 0;
				$v_img                        = apply_filters( 'ult_get_img_single', $pax_settings['video_poster'], 'url' );
				$html                        .= '<div class="upb_content_video" data-controls-color="' . esc_attr( $pax_settings['controls_color'] ) . '" data-controls="' . esc_attr( $pax_settings['enable_controls'] ) . '" data-viewport-video="' . esc_attr( $enable_viewport_vdo ) . '" data-ultimate-video="' . esc_url( $pax_settings['video_url'] ) . '" data-ultimate-video2="' . esc_attr( $pax_settings['video_url_2'] ) . '" data-ultimate-video-muted="' . esc_attr( $muted ) . '" data-ultimate-video-loop="' . esc_attr( $loop ) . '" data-ultimate-video-poster="' . esc_attr( $v_img ) . '" data-ultimate-video-autoplay="autoplay" data-bg-override="' . esc_attr( $pax_settings['bg_override'] ) . '" data-upb-overlay-color="' . esc_attr( $pax_settings['overlay_color'] ) . '" data-upb-bg-animation="' . esc_attr( $pax_settings['bg_fade'] ) . '" data-fadeout="' . esc_attr( $pax_settings['fadeout_row'] ) . '" data-fadeout-percentage="' . esc_attr( $pax_settings['fadeout_start_effect'] ) . '" data-parallax-content="' . esc_attr( $pax_settings['parallax_content'] ) . '" data-parallax-content-sense="' . esc_attr( $pax_settings['parallax_content_sense'] ) . '" data-row-effect-mobile-disable="' . esc_attr( $pax_settings['disable_on_mobile'] ) . '" data-rtl="' . esc_attr( $rtl ) . '" data-img-parallax-mobile-disable="' . esc_attr( $pax_settings['disable_on_mobile_img_parallax'] ) . '" ' . $commom_data_attributes . ' ' . $overlay . ' ' . $seperator_html . ' ' . $ult_hide_row_data . ' data-video_fixer="' . esc_attr( $pax_settings['video_fixer'] ) . '"></div>';

				if ( 'display_control' == $pax_settings['enable_controls'] ) {
					wp_enqueue_style( 'ultimate-vidcons', plugins_url( 'assets/fonts/vidcons.css', __FILE__ ), VC_PARALLAX_BG_VERSION, true );
				}
			} elseif ( 'u_iframe' == $pax_settings['bg_type'] ) {
				wp_enqueue_script( 'jquery.ytplayer', plugins_url( 'assets/js/mb-YTPlayer.js', __FILE__ ), array( 'ultimate-custom' ), VC_PARALLAX_BG_VERSION, true );
				$v_opts = explode( ',', $pax_settings['video_opts'] );
				$v_img  = apply_filters( 'ult_get_img_single', $pax_settings['video_poster'], 'url' );
				if ( is_array( $v_opts ) ) {
					foreach ( $v_opts as $opt ) {
						if ( 'muted' == $opt ) {
							$muted .= $opt;
						}
						if ( 'autoplay' == $opt ) {
							$autoplay .= $opt;
						}
						if ( 'loop' == $opt ) {
							$loop .= $opt;
						}
					}
				}
				if ( 'viewport_play' === $pax_settings['viewport_vdo'] ) {
					$enable_viewport_vdo = 'true';
				} else {
					$enable_viewport_vdo = 'false';
				}

				$video_fixer_option = get_option( 'ultimate_video_fixer' );
				if ( $video_fixer_option ) {
					if ( 'enable' == $video_fixer_option ) {
						$pax_settings['video_fixer'] = 'false';
					}
				}

				$html .= '<div class="upb_content_iframe" data-controls="' . esc_attr( $pax_settings['enable_controls'] ) . '" data-viewport-video="' . esc_attr( $enable_viewport_vdo ) . '" data-ultimate-video="' . esc_attr( $pax_settings['u_video_url'] ) . '" data-bg-override="' . esc_attr( $pax_settings['bg_override'] ) . '" data-start-time="' . esc_attr( $pax_settings['u_start_time'] ) . '" data-stop-time="' . esc_attr( $pax_settings['u_stop_time'] ) . '" data-ultimate-video-muted="' . esc_attr( $muted ) . '" data-ultimate-video-loop="' . esc_attr( $loop ) . '" data-ultimate-video-poster="' . esc_attr( $v_img ) . '" data-upb-overlay-color="' . esc_attr( $pax_settings['overlay_color'] ) . '" data-upb-bg-animation="' . esc_attr( $pax_settings['bg_fade'] ) . '" data-fadeout="' . esc_attr( $pax_settings['fadeout_row'] ) . '" data-fadeout-percentage="' . esc_attr( $pax_settings['fadeout_start_effect'] ) . '"  data-parallax-content="' . esc_attr( $pax_settings['parallax_content'] ) . '" data-parallax-content-sense="' . esc_attr( $pax_settings['parallax_content_sense'] ) . '" data-row-effect-mobile-disable="' . esc_attr( $pax_settings['disable_on_mobile'] ) . '" data-img-parallax-mobile-disable="' . esc_attr( $pax_settings['disable_on_mobile_img_parallax'] ) . '" data-rtl="' . esc_attr( $rtl ) . '" ' . $commom_data_attributes . ' ' . $overlay . ' ' . $seperator_html . ' ' . $ult_hide_row_data . ' data-video_fixer="' . esc_attr( $pax_settings['video_fixer'] ) . '"></div>';
			} elseif ( 'grad' == $pax_settings['bg_type'] ) {
				$html .= '<div class="upb_grad" data-grad="' . esc_attr( $pax_settings['bg_grad'] ) . '" data-bg-override="' . esc_attr( $pax_settings['bg_override'] ) . '" data-upb-overlay-color="' . esc_attr( $pax_settings['overlay_color'] ) . '" data-upb-bg-animation="' . esc_attr( $pax_settings['bg_fade'] ) . '" data-fadeout="' . esc_attr( $pax_settings['fadeout_row'] ) . '" data-fadeout-percentage="' . esc_attr( $pax_settings['fadeout_start_effect'] ) . '" data-parallax-content="' . esc_attr( $pax_settings['parallax_content'] ) . '" data-parallax-content-sense="' . esc_attr( $pax_settings['parallax_content_sense'] ) . '" data-row-effect-mobile-disable="' . esc_attr( $pax_settings['disable_on_mobile'] ) . '" data-img-parallax-mobile-disable="' . esc_attr( $pax_settings['disable_on_mobile_img_parallax'] ) . '" data-rtl="' . esc_Attr( $rtl ) . '" ' . $commom_data_attributes . ' ' . $overlay . ' ' . $seperator_html . ' ' . $ult_hide_row_data . '></div>';
			} elseif ( 'bg_color' == $pax_settings['bg_type'] ) {
				$html .= '<div class="upb_color" data-bg-override="' . esc_attr( $pax_settings['bg_override'] ) . '" data-bg-color="' . esc_attr( $pax_settings['bg_color_value'] ) . '" data-fadeout="' . esc_attr( $pax_settings['fadeout_row'] ) . '" data-fadeout-percentage="' . esc_attr( $pax_settings['fadeout_start_effect'] ) . '" data-parallax-content="' . esc_attr( $pax_settings['parallax_content'] ) . '" data-parallax-content-sense="' . esc_attr( $pax_settings['parallax_content_sense'] ) . '" data-row-effect-mobile-disable="' . esc_attr( $pax_settings['disable_on_mobile'] ) . '" data-img-parallax-mobile-disable="' . esc_attr( $pax_settings['disable_on_mobile_img_parallax'] ) . '" data-rtl="' . esc_attr( $rtl ) . '" ' . $commom_data_attributes . ' ' . $overlay . ' ' . $seperator_html . ' ' . $ult_hide_row_data . '></div>';
			}
				$output .= $html;
			if ( 'theme_default' == $pax_settings['bg_type'] ) {
				return false;
			} else {
				$this->front_scripts();
				return $output;
			}
		} /* end parallax_shortcode */
		/**
		 * Execute parallax.
		 *
		 * @access public
		 */
		public function parallax_init() {
			$group_name    = 'Background';
			$group_effects = 'Effect';
			if ( function_exists( 'vc_remove_param' ) ) {
				vc_remove_param( 'vc_row', 'bg_image_repeat' );
			}

			$pluginname = dirname( plugin_basename( __FILE__ ) );

			$patterns_path = realpath( plugin_dir_path( __FILE__ ) . '/assets/images/patterns' );

			$patterns_list = glob( $patterns_path . '/*.*' );
			$patterns      = array();

			foreach ( $patterns_list as $pattern ) {
				$patterns[ basename( $pattern ) ] = plugins_url() . '/' . $pluginname . '/assets/images/patterns/' . basename( $pattern );
			}

			if ( function_exists( 'vc_add_param' ) ) {
				vc_add_param(
					'vc_row',
					array(
						'type'        => 'dropdown',
						'class'       => '',
						'admin_label' => true,
						'heading'     => __( 'Background Style', 'upb_parallax' ),
						'param_name'  => 'bg_type',
						'value'       => array(
							__( 'Default', 'upb_parallax' ) => 'no_bg',
							__( 'Single Color', 'upb_parallax' ) => 'bg_color',
							__( 'Gradient Color', 'upb_parallax' ) => 'grad',
							__( 'Image / Parallax', 'upb_parallax' ) => 'image',
							__( 'YouTube Video', 'upb_parallax' ) => 'u_iframe',
							__( 'Hosted Video', 'upb_parallax' ) => 'video',
						),
						'description' => __( "Select the kind of background would you like to set for this row. Not sure? See Narrated <a href='https://www.youtube.com/watch?v=Qxs8R-uaMWk&list=PL1kzJGWGPrW981u5caHy6Kc9I1bG1POOx' target='_blank'>Video Tutorials</a>", 'upb_parallax' ),
						'group'       => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'        => 'gradient',
						'class'       => '',
						'heading'     => __( 'Gradient Type', 'upb_parallax' ),
						'param_name'  => 'bg_grad',
						'description' => __( 'At least two color points should be selected. <a href="https://www.youtube.com/watch?v=yE1M4AKwS44" target="_blank">Video Tutorial</a>', 'upb_parallax' ),
						'dependency'  => array(
							'element' => 'bg_type',
							'value'   => array( 'grad' ),
						),
						'group'       => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'       => 'colorpicker',
						'class'      => '',
						'heading'    => __( 'Background Color', 'upb_parallax' ),
						'param_name' => 'bg_color_value',
						'dependency' => array(
							'element' => 'bg_type',
							'value'   => array( 'bg_color' ),
						),
						'group'      => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'        => 'dropdown',
						'class'       => '',
						'heading'     => __( 'Parallax Style', 'upb_parallax' ),
						'param_name'  => 'parallax_style',
						'value'       => array(
							__( 'Simple Background Image', 'upb_parallax' ) => 'vcpb-default',
							__( 'Auto Moving Background', 'upb_parallax' ) => 'vcpb-animated',
							__( 'Vertical Parallax On Scroll', 'upb_parallax' ) => 'vcpb-vz-jquery',
							__( 'Horizontal Parallax On Scroll', 'upb_parallax' ) => 'vcpb-hz-jquery',
							__( 'Interactive Parallax On Mouse Hover', 'upb_parallax' ) => 'vcpb-fs-jquery',
							__( 'Multilayer Vertical Parallax', 'upb_parallax' ) => 'vcpb-mlvp-jquery',
						),
						'description' => __( 'Select the kind of style you like for the background.', 'upb_parallax' ),
						'dependency'  => array(
							'element' => 'bg_type',
							'value'   => array( 'image' ),
						),
						'group'       => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'        => 'attach_image',
						'class'       => '',
						'heading'     => __( 'Background Image', 'upb_parallax' ),
						'param_name'  => 'bg_image_new',
						'value'       => '',
						'description' => __( 'Upload or select background image from media gallery.', 'upb_parallax' ),
						'dependency'  => array(
							'element' => 'parallax_style',
							'value'   => array( 'vcpb-default', 'vcpb-animated', 'vcpb-vz-jquery', 'vcpb-hz-jquery' ),
						),
						'group'       => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'        => 'attach_images',
						'class'       => '',
						'heading'     => __( 'Layer Images', 'upb_parallax' ),
						'param_name'  => 'layer_image',
						'value'       => '',
						'description' => __( 'Upload or select background images from media gallery.', 'upb_parallax' ),
						'dependency'  => array(
							'element' => 'parallax_style',
							'value'   => array( 'vcpb-fs-jquery', 'vcpb-mlvp-jquery' ),
						),
						'group'       => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'        => 'dropdown',
						'class'       => '',
						'heading'     => __( 'Background Image Repeat', 'upb_parallax' ),
						'param_name'  => 'bg_image_repeat',
						'value'       => array(
							__( 'Repeat', 'upb_parallax' ) => 'repeat',
							__( 'Repeat X', 'upb_parallax' ) => 'repeat-x',
							__( 'Repeat Y', 'upb_parallax' ) => 'repeat-y',
							__( 'No Repeat', 'upb_parallax' ) => 'no-repeat',
						),
						'description' => __( "Options to control repeatation of the background image. Learn on <a href='http://www.w3schools.com/cssref/playit.asp?filename=playcss_background-repeat' target='_blank'>W3School</a>", 'upb_parallax' ),
						'dependency'  => array(
							'element' => 'parallax_style',
							'value'   => array( 'vcpb-default', 'vcpb-fix', 'vcpb-vz-jquery', 'vcpb-hz-jquery' ),
						),
						'group'       => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'        => 'dropdown',
						'class'       => '',
						'heading'     => __( 'Background Image Size', 'upb_parallax' ),
						'param_name'  => 'bg_image_size',
						'value'       => array(
							__( 'Cover - Image to be as large as possible', 'upb_parallax' ) => 'cover',
							__( 'Contain - Image will try to fit inside the container area', 'upb_parallax' ) => 'contain',
							__( 'Initial', 'upb_parallax' ) => 'initial',
						),
						'description' => __( "Options to control size of the background image. Learn on <a href='http://www.w3schools.com/cssref/playit.asp?filename=playcss_background-size&preval=50%25' target='_blank'>W3School</a>", 'upb_parallax' ),
						'dependency'  => array(
							'element' => 'parallax_style',
							'value'   => array( 'vcpb-default', 'vcpb-animated', 'vcpb-fix', 'vcpb-vz-jquery', 'vcpb-hz-jquery' ),
						),
						'group'       => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'        => 'textfield',
						'class'       => '',
						'heading'     => __( 'Custom Background Image Size', 'upb_parallax' ),
						'param_name'  => 'bg_cstm_size',
						'value'       => '',
						'description' => __( 'You can use initial, inherit or any number with px, em, %, etc. Example- 100px 100px', 'upb_parallax' ),
						'dependency'  => array(
							'element' => 'bg_image_size',
							'value'   => array( 'cstm' ),
						),
						'group'       => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'        => 'dropdown',
						'class'       => '',
						'heading'     => __( 'Scroll Effect', 'upb_parallax' ),
						'param_name'  => 'bg_img_attach',
						'value'       => array(
							__( 'Move with the content', 'upb_parallax' ) => 'scroll',
							__( 'Fixed at its position', 'upb_parallax' ) => 'fixed',
						),
						'description' => __( 'Options to set whether a background image is fixed or scroll with the rest of the page.', 'upb_parallax' ),
						'dependency'  => array(
							'element' => 'parallax_style',
							'value'   => array( 'vcpb-default', 'vcpb-animated', 'vcpb-hz-jquery', 'vcpb-vz-jquery' ),
						),
						'group'       => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'        => 'number',
						'class'       => '',
						'heading'     => __( 'Parallax Speed', 'upb_parallax' ),
						'param_name'  => 'parallax_sense',
						'value'       => '30',
						'min'         => '1',
						'max'         => '100',
						'description' => __( 'Control speed of parallax. Enter value between 1 to 100', 'upb_parallax' ),
						'dependency'  => array(
							'element' => 'parallax_style',
							'value'   => array( 'vcpb-vz-jquery', 'vcpb-animated', 'vcpb-hz-jquery', 'vcpb-vs-jquery', 'vcpb-hs-jquery', 'vcpb-fs-jquery', 'vcpb-mlvp-jquery' ),
						),
						'group'       => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'        => 'textfield',
						'class'       => '',
						'heading'     => __( 'Background Image Posiiton', 'upb_parallax' ),
						'param_name'  => 'bg_image_posiiton',
						'value'       => '',
						'description' => __( 'You can use any number with px, em, %, etc. Example- 100px 100px.', 'upb_parallax' ),
						'dependency'  => array(
							'element' => 'parallax_style',
							'value'   => array( 'vcpb-default', 'vcpb-fix' ),
						),
						'group'       => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'       => 'dropdown',
						'class'      => '',
						'heading'    => __( 'Animation Direction', 'upb_parallax' ),
						'param_name' => 'animation_direction',
						'value'      => array(
							__( 'Left to Right', 'upb_parallax' ) => 'left-animation',
							__( 'Right to Left', 'upb_parallax' ) => 'right-animation',
							__( 'Top to Bottom', 'upb_parallax' ) => 'top-animation',
							__( 'Bottom to Top', 'upb_parallax' ) => 'bottom-animation',

						),
						'dependency' => array(
							'element' => 'parallax_style',
							'value'   => array( 'vcpb-animated' ),
						),
						'group'      => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'       => 'dropdown',
						'class'      => '',
						'heading'    => __( 'Background Repeat', 'upb_parallax' ),
						'param_name' => 'animation_repeat',
						'value'      => array(
							__( 'Repeat', 'upb_parallax' ) => 'repeat',
							__( 'Repeat X', 'upb_parallax' ) => 'repeat-x',
							__( 'Repeat Y', 'upb_parallax' ) => 'repeat-y',
						),
						'dependency' => array(
							'element' => 'parallax_style',
							'value'   => array( 'vcpb-animated' ),
						),
						'group'      => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'       => 'textfield',
						'class'      => '',
						'heading'    => __( 'Link to the video in MP4 Format', 'upb_parallax' ),
						'param_name' => 'video_url',
						'value'      => '',
						'dependency' => array(
							'element' => 'bg_type',
							'value'   => array( 'video' ),
						),
						'group'      => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'        => 'textfield',
						'class'       => '',
						'heading'     => __( 'Link to the video in WebM / Ogg Format', 'upb_parallax' ),
						'param_name'  => 'video_url_2',
						'value'       => '',
						'description' => __( "IE, Chrome & Safari <a href='http://www.w3schools.com/html/html5_video.asp' target='_blank'>support</a> MP4 format, while Firefox & Opera prefer WebM / Ogg formats. You can upload the video through <a href='" . home_url() . "/wp-admin/media-new.php' target='_blank'>WordPress Media Library</a>.", 'upb_parallax' ),// @codingStandardsIgnoreLine.
						'dependency'  => array(
							'element' => 'bg_type',
							'value'   => array( 'video' ),
						),
						'group'       => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'        => 'textfield',
						'class'       => '',
						'heading'     => __( 'Enter YouTube URL of the Video', 'upb_parallax' ),
						'param_name'  => 'u_video_url',
						'value'       => '',
						'description' => __( 'Enter YouTube url. Example - YouTube (https://www.youtube.com/watch?v=tSqJIIcxKZM) ', 'upb_parallax' ),
						'dependency'  => array(
							'element' => 'bg_type',
							'value'   => array( 'u_iframe' ),
						),
						'group'       => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'       => 'checkbox',
						'class'      => '',
						'heading'    => __( 'Extra Options', 'upb_parallax' ),
						'param_name' => 'video_opts',
						'value'      => array(
							__( 'Loop', 'upb_parallax' )  => 'loop',
							__( 'Muted', 'upb_parallax' ) => 'muted',
						),
						'dependency' => array(
							'element' => 'bg_type',
							'value'   => array( 'video', 'u_iframe' ),
						),
						'group'      => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'        => 'attach_image',
						'class'       => '',
						'heading'     => __( 'Placeholder Image', 'upb_parallax' ),
						'param_name'  => 'video_poster',
						'value'       => '',
						'description' => __( 'Placeholder image is displayed in case background videos are restricted (Ex - on iOS devices).', 'upb_parallax' ),
						'dependency'  => array(
							'element' => 'bg_type',
							'value'   => array( 'video', 'u_iframe' ),
						),
						'group'       => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'       => 'number',
						'class'      => '',
						'heading'    => __( 'Start Time', 'upb_parallax' ),
						'param_name' => 'u_start_time',
						'value'      => '',
						'suffix'     => 'seconds',
						'dependency' => array(
							'element' => 'bg_type',
							'value'   => array( 'u_iframe' ),
						),
						'group'      => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'        => 'number',
						'class'       => '',
						'heading'     => __( 'Stop Time', 'upb_parallax' ),
						'param_name'  => 'u_stop_time',
						'value'       => '',
						'suffix'      => 'seconds',
						'description' => __( 'You may start / stop the video at any point you would like.', 'upb_parallax' ),
						'dependency'  => array(
							'element' => 'bg_type',
							'value'   => array( 'u_iframe' ),
						),
						'group'       => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'        => 'ult_switch',
						'class'       => '',
						'heading'     => __( 'Play video only when in viewport', 'upb_parallax' ),
						'param_name'  => 'viewport_vdo',
						'value'       => '',
						'options'     => array(
							'viewport_play' => array(
								'label' => '',
								'on'    => 'Yes',
								'off'   => 'No',
							),
						),
						'description' => __( 'Video will be played only when user is on the particular screen position. Once user scroll away, the video will pause.', 'upb_parallax' ),
						'dependency'  => array(
							'element' => 'bg_type',
							'value'   => array( 'video', 'u_iframe' ),
						),
						'group'       => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'        => 'ult_switch',
						'class'       => '',
						'heading'     => __( 'Display Controls', 'upb_parallax' ),
						'param_name'  => 'enable_controls',
						'value'       => '',
						'options'     => array(
							'display_control' => array(
								'label' => '',
								'on'    => 'Yes',
								'off'   => 'No',
							),
						),
						'description' => __( 'Display play / pause controls for the video on bottom right position.', 'upb_parallax' ),
						'dependency'  => array(
							'element' => 'bg_type',
							'value'   => array( 'video' ),
						),
						'group'       => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'       => 'colorpicker',
						'class'      => '',
						'heading'    => __( 'Color of Controls Icon', 'upb_parallax' ),
						'param_name' => 'controls_color',
						'dependency' => array(
							'element' => 'enable_controls',
							'value'   => array( 'display_control' ),
						),
						'group'      => $group_name,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'        => 'dropdown',
						'class'       => '',
						'heading'     => __( 'Background Override (Read Description)', 'upb_parallax' ),
						'param_name'  => 'bg_override',
						'value'       => array(
							'Default Width'          => '0',
							"Apply 1st parent element's width" => '1',
							"Apply 2nd parent element's width" => '2',
							"Apply 3rd parent element's width" => '3',
							"Apply 4th parent element's width" => '4',
							"Apply 5th parent element's width" => '5',
							"Apply 6th parent element's width" => '6',
							"Apply 7th parent element's width" => '7',
							"Apply 8th parent element's width" => '8',
							"Apply 9th parent element's width" => '9',
							'Full Width '            => 'full',
							'Maximum Full Width'     => 'ex-full',
							'Browser Full Dimension' => 'browser_size',
						),
						'description' => __( "By default, the background will be given to the WPBakery Page Builder row. However, in some cases depending on your theme's CSS - it may not fit well to the container you are wishing it would. In that case you will have to select the appropriate value here that gets you desired output..", 'upb_parallax' ),
						'dependency'  => array(
							'element' => 'bg_type',
							'value'   => array( 'u_iframe', 'image', 'video', 'grad', 'bg_color', 'animated' ),
						),
						'group'       => $group_name,
					)
				);

				vc_add_param(
					'vc_row',
					array(
						'type'       => 'ult_switch',
						'class'      => '',
						'heading'    => __( 'Activate on Mobile', 'upb_parallax' ),
						'param_name' => 'disable_on_mobile_img_parallax',
						'value'      => '',
						'options'    => array(
							'disable_on_mobile_img_parallax_value' => array(
								'label' => '',
								'on'    => 'Yes',
								'off'   => 'No',
							),
						),
						'group'      => $group_name,
						'dependency' => array(
							'element' => 'parallax_style',
							'value'   => array( 'vcpb-animated', 'vcpb-vz-jquery', 'vcpb-hz-jquery', 'vcpb-fs-jquery', 'vcpb-mlvp-jquery' ),
						),
					)
				);

				vc_add_param(
					'vc_row',
					array(
						'type'             => 'ult_switch',
						'class'            => '',
						'heading'          => __( 'Easy Parallax', 'upb_parallax' ),
						'param_name'       => 'parallax_content',
						'value'            => '',
						'options'          => array(
							'parallax_content_value' => array(
								'label' => '',
								'on'    => 'Yes',
								'off'   => 'No',
							),
						),
						'group'            => $group_effects,
						'edit_field_class' => 'uvc-divider last-uvc-divider vc_column vc_col-sm-12',
						'description'      => __( 'If enabled, the elements inside row - will move slowly as user scrolls.', 'upb_parallax' ),
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'        => 'textfield',
						'class'       => '',
						'heading'     => __( 'Parallax Speed', 'upb_parallax' ),
						'param_name'  => 'parallax_content_sense',
						'value'       => '30',
						'group'       => $group_effects,
						'description' => __( 'Enter value between 0 to 100', 'upb_parallax' ),
						'dependency'  => array(
							'element' => 'parallax_content',
							'value'   => array( 'parallax_content_value' ),
						),
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'             => 'ult_switch',
						'class'            => '',
						'heading'          => __( 'Fade Effect on Scroll', 'upb_parallax' ),
						'param_name'       => 'fadeout_row',
						'value'            => '',
						'options'          => array(
							'fadeout_row_value' => array(
								'label' => '',
								'on'    => 'Yes',
								'off'   => 'No',
							),
						),
						'group'            => $group_effects,
						'edit_field_class' => 'uvc-divider last-uvc-divider vc_column vc_col-sm-12',
						'description'      => __( 'If enabled, the the content inside row will fade out slowly as user scrolls down.', 'upb_parallax' ),
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'        => 'number',
						'class'       => '',
						'heading'     => __( 'Viewport Position', 'upb_parallax' ),
						'param_name'  => 'fadeout_start_effect',
						'suffix'      => '%',
						'value'       => '30',
						'group'       => $group_effects,
						'description' => __( 'The area of screen from top where fade out effect will take effect once the row is completely inside that area.', 'upb_parallax' ),
						'dependency'  => array(
							'element' => 'fadeout_row',
							'value'   => array( 'fadeout_row_value' ),
						),
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'             => 'ult_switch',
						'heading'          => __( 'Enable Overlay', 'upb_parallax' ),
						'param_name'       => 'enable_overlay',
						'value'            => '',
						'options'          => array(
							'enable_overlay_value' => array(
								'label' => '',
								'on'    => 'Yes',
								'off'   => 'No',
							),
						),
						'edit_field_class' => 'uvc-divider last-uvc-divider vc_column vc_col-sm-12',
						'group'            => $group_effects,
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'        => 'colorpicker',
						'heading'     => __( 'Color', 'upb_parallax' ),
						'param_name'  => 'overlay_color',
						'value'       => '',
						'group'       => $group_effects,
						'dependency'  => array(
							'element' => 'enable_overlay',
							'value'   => array( 'enable_overlay_value' ),
						),
						'description' => __( 'Select RGBA values or opacity will be set to 20% by default.', 'upb_parallax' ),
					)
				);

				vc_add_param(
					'vc_row',
					array(
						'type'       => 'radio_image_box',
						'heading'    => __( 'Pattern', 'upb_parallax' ),
						'param_name' => 'overlay_pattern',
						'value'      => '',
						'options'    => $patterns,
						'css'        => array(
							'width'             => '40px',
							'height'            => '35px',
							'background-repeat' => 'repeat',
							'background-size'   => 'cover',
						),
						'group'      => $group_effects,
						'dependency' => array(
							'element' => 'enable_overlay',
							'value'   => array( 'enable_overlay_value' ),
						),
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'             => 'number',
						'heading'          => __( 'Pattern Opacity', 'upb_parallax' ),
						'param_name'       => 'overlay_pattern_opacity',
						'value'            => '80',
						'min'              => '0',
						'max'              => '100',
						'suffix'           => '%',
						'group'            => $group_effects,
						'dependency'       => array(
							'element' => 'enable_overlay',
							'value'   => array( 'enable_overlay_value' ),
						),
						'description'      => __( 'Enter value between 0 to 100 (0 is maximum transparency, while 100 is minimum)', 'upb_parallax' ),
						'edit_field_class' => 'vc_column vc_col-sm-4',
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'             => 'number',
						'heading'          => __( 'Pattern Size', 'upb_parallax' ),
						'param_name'       => 'overlay_pattern_size',
						'value'            => '',
						'suffix'           => 'px',
						'group'            => $group_effects,
						'dependency'       => array(
							'element' => 'enable_overlay',
							'value'   => array( 'enable_overlay_value' ),
						),
						'description'      => __( 'This is optional; sets the size of the pattern image manually.', 'upb_parallax' ),
						'edit_field_class' => 'vc_column vc_col-sm-4',
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'             => 'dropdown',
						'heading'          => __( 'Pattern Scroll Effect', 'upb_parallax' ),
						'param_name'       => 'overlay_pattern_attachment',
						'value'            => array(
							__( 'Fixed at its position', 'upb_parallax' ) => 'fixed',
							__( 'Move with the Content', 'upb_parallax' ) => 'scroll',
						),
						'group'            => $group_effects,
						'dependency'       => array(
							'element' => 'enable_overlay',
							'value'   => array( 'enable_overlay_value' ),
						),
						'edit_field_class' => 'vc_column vc_col-sm-4',
					)
				);

				vc_add_param(
					'vc_row',
					array(
						'type'             => 'checkbox',
						'heading'          => __( 'Fancy Multi Color Overlay', 'upb_parallax' ),
						'param_name'       => 'multi_color_overlay',
						'value'            => array(
							__( 'Enable', 'upb_parallax' ) => 'uvc-multi-color-bg',
						),
						'group'            => $group_effects,
						'dependency'       => array(
							'element' => 'enable_overlay',
							'value'   => array( 'enable_overlay_value' ),
						),
						'edit_field_class' => 'vc_column vc_col-sm-4 clear',
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'             => 'number',
						'heading'          => __( 'Multi Color Overlay Opacity', 'upb_parallax' ),
						'param_name'       => 'multi_color_overlay_opacity',
						'value'            => '60',
						'suffix'           => '%',
						'group'            => $group_effects,
						'dependency'       => array(
							'element' => 'multi_color_overlay',
							'value'   => array( 'uvc-multi-color-bg' ),
						),
						'edit_field_class' => 'vc_column vc_col-sm-8',
					)
				);

				vc_add_param(
					'vc_row',
					array(
						'type'             => 'ult_switch',
						'heading'          => __( 'Seperator ', 'upb_parallax' ),
						'param_name'       => 'seperator_enable',
						'value'            => '',
						'options'          => array(
							'seperator_enable_value' => array(
								'on'  => 'Yes',
								'off' => 'No',
							),
						),
						'edit_field_class' => 'uvc-divider last-uvc-divider vc_column vc_col-sm-12',
						'group'            => $group_effects,
					)
				);

				vc_add_param(
					'vc_row',
					array(
						'type'             => 'dropdown',
						'heading'          => __( 'Type', 'upb_parallax' ),
						'param_name'       => 'seperator_type',
						'value'            => array(
							__( 'None', 'upb_parallax' )   => 'none_seperator',
							__( 'Triangle', 'upb_parallax' ) => 'triangle_svg_seperator',
							__( 'Big Triangle', 'upb_parallax' ) => 'xlarge_triangle_seperator',
							__( 'Big Triangle Left', 'upb_parallax' ) => 'xlarge_triangle_left_seperator',
							__( 'Big Triangle Right', 'upb_parallax' ) => 'xlarge_triangle_right_seperator',
							__( 'Half Circle', 'upb_parallax' ) => 'circle_svg_seperator',
							__( 'Curve Center', 'upb_parallax' ) => 'xlarge_circle_seperator',
							__( 'Curve Left', 'upb_parallax' ) => 'curve_up_seperator',
							__( 'Curve Right', 'upb_parallax' ) => 'curve_down_seperator',
							__( 'Tilt Left', 'upb_parallax' ) => 'tilt_left_seperator',
							__( 'Tilt Right', 'upb_parallax' ) => 'tilt_right_seperator',
							__( 'Round Split', 'upb_parallax' ) => 'round_split_seperator',
							__( 'Waves', 'upb_parallax' )  => 'waves_seperator',
							__( 'Clouds', 'upb_parallax' ) => 'clouds_seperator',
							__( 'Multi Triangle', 'upb_parallax' ) => 'multi_triangle_seperator',
						),
						'group'            => $group_effects,
						'dependency'       => array(
							'element' => 'seperator_enable',
							'value'   => array( 'seperator_enable_value' ),
						),
						'edit_field_class' => 'uvc-divider-content-first vc_column vc_col-sm-12',
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'             => 'dropdown',
						'heading'          => __( 'Position', 'upb_parallax' ),
						'param_name'       => 'seperator_position',
						'value'            => array(
							__( 'Top', 'upb_parallax' )    => 'top_seperator',
							__( 'Bottom', 'upb_parallax' ) => 'bottom_seperator',
							__( 'Top & Bottom', 'upb_parallax' ) => 'top_bottom_seperator',
						),
						'group'            => $group_effects,
						'dependency'       => array(
							'element' => 'seperator_enable',
							'value'   => array( 'seperator_enable_value' ),
						),
						'edit_field_class' => 'uvc-divider-content-first vc_column vc_col-sm-12',
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'       => 'number',
						'heading'    => __( 'Size', 'upb_parallax' ),
						'param_name' => 'seperator_shape_size',
						'value'      => '40',
						'suffix'     => 'px',
						'group'      => $group_effects,
						'dependency' => array(
							'element' => 'seperator_type',
							'value'   => array( 'triangle_seperator', 'circle_seperator', 'round_split_seperator' ),
						),
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'       => 'number',
						'heading'    => __( 'Height', 'upb_parallax' ),
						'param_name' => 'seperator_svg_height',
						'value'      => '60',
						'suffix'     => 'px',
						'group'      => $group_effects,
						'dependency' => array(
							'element' => 'seperator_type',
							'value'   => array( 'xlarge_triangle_seperator', 'curve_up_seperator', 'curve_down_seperator', 'waves_seperator', 'clouds_seperator', 'xlarge_circle_seperator', 'triangle_svg_seperator', 'circle_svg_seperator', 'xlarge_triangle_left_seperator', 'xlarge_triangle_right_seperator', 'tilt_left_seperator', 'tilt_right_seperator', 'multi_triangle_seperator' ),
						),
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'        => 'colorpicker',
						'heading'     => __( 'Background', 'upb_parallax' ),
						'param_name'  => 'seperator_shape_background',
						'value'       => '#fff',
						'group'       => $group_effects,
						'dependency'  => array(
							'element' => 'seperator_type',
							'value'   => array( 'xlarge_triangle_seperator', 'triangle_seperator', 'circle_seperator', 'curve_up_seperator', 'curve_down_seperator', 'round_split_seperator', 'waves_seperator', 'clouds_seperator', 'xlarge_circle_seperator', 'triangle_svg_seperator', 'circle_svg_seperator', 'xlarge_triangle_left_seperator', 'xlarge_triangle_right_seperator', 'tilt_left_seperator', 'tilt_right_seperator', 'multi_triangle_seperator' ),
						),
						'description' => __( 'Mostly, this should be background color of your adjacent row section.', 'upb_parallax' ),
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'       => 'dropdown',
						'heading'    => __( 'Border', 'upb_parallax' ),
						'param_name' => 'seperator_shape_border',
						'value'      => array(
							__( 'None', 'upb_parallax' )   => 'none',
							__( 'Solid', 'upb_parallax' )  => 'solid',
							__( 'Dotted', 'upb_parallax' ) => 'dotted',
							__( 'Dashed', 'upb_parallax' ) => 'dashed',
						),
						'group'      => $group_effects,
						'dependency' => array(
							'element' => 'seperator_type',
							'value'   => array( 'none_seperator', 'triangle_seperator', 'circle_seperator', 'round_split_seperator' ),
						),
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'       => 'colorpicker',
						'heading'    => __( 'Border Color', 'upb_parallax' ),
						'param_name' => 'seperator_shape_border_color',
						'value'      => '',
						'group'      => $group_effects,
						'dependency' => array(
							'element' => 'seperator_type',
							'value'   => array( 'none_seperator', 'triangle_seperator', 'circle_seperator', 'round_split_seperator' ),
						),
					)
				);
				vc_add_param(
					'vc_row',
					array(
						'type'             => 'number',
						'heading'          => __( 'Border Width', 'upb_parallax' ),
						'param_name'       => 'seperator_shape_border_width',
						'value'            => '1',
						'suffix'           => 'px',
						'group'            => $group_effects,
						'dependency'       => array(
							'element' => 'seperator_type',
							'value'   => array( 'none_seperator', 'triangle_seperator', 'circle_seperator', 'round_split_seperator' ),
						),
						'edit_field_class' => 'uvc-divider-content-last vc_column vc_col-sm-12',
					)
				);

				vc_add_param(
					'vc_row',
					array(
						'type'             => 'ult_switch',
						'heading'          => __( 'Hide Row', 'upb_parallax' ),
						'param_name'       => 'ult_hide_row',
						'value'            => '',
						'options'          => array(
							'ult_hide_row_value' => array(
								'on'  => 'Yes',
								'off' => 'No',
							),
						),
						'edit_field_class' => 'uvc-divider last-uvc-divider vc_column vc_col-sm-12',
						'group'            => $group_effects,
					)
				);

				vc_add_param(
					'vc_row',
					array(
						'type'             => 'ult_switch',
						'heading'          => __( '<i class="dashicons dashicons-welcome-view-site"></i> Large Screen', 'upb_parallax' ),
						'param_name'       => 'ult_hide_row_large_screen',
						'value'            => '',
						'options'          => array(
							'large_screen' => array(
								'on'  => 'Yes',
								'off' => 'No',
							),
						),
						'group'            => $group_effects,
						'dependency'       => array(
							'element' => 'ult_hide_row',
							'value'   => array( 'ult_hide_row_value' ),
						),
						'edit_field_class' => 'vc_column vc_col-sm-4',
					)
				);

				vc_add_param(
					'vc_row',
					array(
						'type'             => 'ult_switch',
						'heading'          => __( '<i class="dashicons dashicons-desktop"></i> Desktop', 'upb_parallax' ),
						'param_name'       => 'ult_hide_row_desktop',
						'value'            => '',
						'options'          => array(
							'desktop' => array(
								'on'  => 'Yes',
								'off' => 'No',
							),
						),
						'group'            => $group_effects,
						'dependency'       => array(
							'element' => 'ult_hide_row',
							'value'   => array( 'ult_hide_row_value' ),
						),
						'edit_field_class' => 'vc_column vc_col-sm-4',
					)
				);

				vc_add_param(
					'vc_row',
					array(
						'type'             => 'ult_switch',
						'heading'          => __( '<i class="dashicons dashicons-tablet" style="transform: rotate(90deg);"></i> Tablet', 'upb_parallax' ),
						'param_name'       => 'ult_hide_row_tablet',
						'value'            => '',
						'options'          => array(
							'tablet' => array(
								'on'  => 'Yes',
								'off' => 'No',
							),
						),
						'group'            => $group_effects,
						'dependency'       => array(
							'element' => 'ult_hide_row',
							'value'   => array( 'ult_hide_row_value' ),
						),
						'edit_field_class' => 'vc_column vc_col-sm-4',
					)
				);

				vc_add_param(
					'vc_row',
					array(
						'type'             => 'ult_switch',
						'heading'          => __( '<i class="dashicons dashicons-tablet"></i> Tablet Portrait', 'upb_parallax' ),
						'param_name'       => 'ult_hide_row_tablet_small',
						'value'            => '',
						'options'          => array(
							'xs_tablet' => array(
								'on'  => 'Yes',
								'off' => 'No',
							),
						),
						'group'            => $group_effects,
						'dependency'       => array(
							'element' => 'ult_hide_row',
							'value'   => array( 'ult_hide_row_value' ),
						),
						'edit_field_class' => 'vc_column vc_col-sm-4',
					)
				);

				vc_add_param(
					'vc_row',
					array(
						'type'             => 'ult_switch',
						'heading'          => __( '<i class="dashicons dashicons-smartphone"></i> Mobile', 'upb_parallax' ),
						'param_name'       => 'ult_hide_row_mobile',
						'value'            => '',
						'options'          => array(
							'mobile' => array(
								'on'  => 'Yes',
								'off' => 'No',
							),
						),
						'group'            => $group_effects,
						'dependency'       => array(
							'element' => 'ult_hide_row',
							'value'   => array( 'ult_hide_row_value' ),
						),
						'edit_field_class' => 'vc_column vc_col-sm-4',
					)
				);

				vc_add_param(
					'vc_row',
					array(
						'type'             => 'ult_switch',
						'heading'          => __( '<i class="dashicons dashicons-smartphone" style="transform: rotate(90deg);"></i> Mobile Landscape', 'upb_parallax' ),
						'param_name'       => 'ult_hide_row_mobile_large',
						'value'            => '',
						'options'          => array(
							'xl_mobile' => array(
								'on'  => 'Yes',
								'off' => 'No',
							),
						),
						'group'            => $group_effects,
						'dependency'       => array(
							'element' => 'ult_hide_row',
							'value'   => array( 'ult_hide_row_value' ),
						),
						'edit_field_class' => 'vc_column vc_col-sm-4',
					)
				);
			}
		} /* parallax_init*/
		/**
		 * Execute shortcode.
		 *
		 * @param mixed $settings settings.
		 * @param mixed $value value.
		 * @access public
		 */
		public function radio_image_settings_field( $settings, $value ) {
			$default_css  = array(
				'width'             => '25px',
				'height'            => '25px',
				'background-repeat' => 'repeat',
				'background-size'   => 'cover',
			);
			$dependency   = '';
			$param_name   = isset( $settings['param_name'] ) ? $settings['param_name'] : '';
			$type         = isset( $settings['type'] ) ? $settings['type'] : '';
			$options      = isset( $settings['options'] ) ? $settings['options'] : '';
			$css          = isset( $settings['css'] ) ? $settings['css'] : $default_css;
			$class        = isset( $settings['class'] ) ? $settings['class'] : '';
			$useextension = ( isset( $settings['useextension'] ) && '' != $settings['useextension'] ) ? $settings['useextension'] : 'true';
			$default      = isset( $settings['default'] ) ? $settings['default'] : 'transperant';

			$uni = uniqid();

			$output  = '';
			$output  = '<input id="radio_image_setting_val_' . $uni . '" class="wpb_vc_param_value ' . esc_attr( $param_name ) . ' ' . esc_attr( $type ) . ' ' . esc_attr( $class ) . ' ' . esc_attr( $value ) . ' vc_ug_gradient" name="' . esc_attr( $param_name ) . '"  style="display:none"  value="' . esc_attr( $value ) . '" ' . esc_attr( $dependency ) . '/>';
			$output .= '<div class="ult-radio-image-box" data-uniqid="' . esc_attr( $uni ) . '">';
			if ( 'transperant' == $value ) {
				$checked = 'checked';
			} else {
				$checked = '';
			}
				$output .= '<label>
					<input type="radio" name="radio_image_' . esc_attr( $uni ) . '" ' . esc_attr( $checked ) . ' class="radio_pattern_image" value="' . esc_attr( $default ) . '" />
					<span class="pattern-background no-bg" style="background:transperant;"></span>
				</label>';
			foreach ( $options as $key => $img_url ) {
				if ( $value == $key ) {
					$checked = 'checked';
				} else {
					$checked = '';
				}
				if ( 'true' != $useextension ) {
					$temp          = pathinfo( $key );
					$temp_filename = $temp['filename'];
					$key           = $temp_filename;
				}
				$output .= '<label>
						<input type="radio" name="radio_image_' . esc_attr( $uni ) . '" ' . esc_attr( $checked ) . ' class="radio_pattern_image" value="' . esc_attr( $key ) . '" />
						<span class="pattern-background" style="background:url(' . esc_url( $img_url ) . ')"></span>
					</label>';
			}
			$output .= '</div>';
			$output .= '<style>
				.ult-radio-image-box label > input{ /* HIDE RADIO */
					display:none;
				}
				.ult-radio-image-box label > input + img{ /* IMAGE STYLES */
					cursor:pointer;
				  	border:2px solid transparent;
				}
				.ult-radio-image-box .no-bg {
					border:2px solid #ccc;
				}
				.ult-radio-image-box label > input:checked + img, .ult-radio-image-box label > input:checked + .pattern-background{ /* (CHECKED) IMAGE STYLES */
				  	border:2px solid #f00;
				}
				.pattern-background {';
			foreach ( $css as $attr => $inine_style ) {
				$output .= $attr . ':' . $inine_style . ';';
			}
					$output .= 'display: inline-block;
					border:2px solid transparent;
				}
			</style>';
			$output         .= '<script type="text/javascript">
				jQuery(".radio_pattern_image").change(function(){
					var radio_id = jQuery(this).parent().parent().data("uniqid");
					var val = jQuery(this).val();
					jQuery("#radio_image_setting_val_"+radio_id).val(val);
				});
			</script>';
			return $output;
		}
	}
	new VC_Ultimate_Parallax();
}
if ( ! function_exists( 'vc_theme_after_vc_row' ) ) {
	/**
	 * For the animation in the module
	 *
	 * @param array  $atts represts module attribuits.
	 * @param string $content value has been set to null.
	 * @access public
	 */
	function vc_theme_after_vc_row( $atts, $content = null ) {
		return apply_filters( 'parallax_image_video', '', $atts, $content );
	}
}

if ( ! function_exists( 'hex2rgb_ult_parallax' ) ) {
	/**
	 * Hex to Rgb
	 *
	 * @param mixed $hex hex number.
	 * @param mixed $opacity color opacity.
	 * @access public
	 */
	function hex2rgb_ult_parallax( $hex, $opacity ) {
		$hex = str_replace( '#', '', $hex );
		if ( preg_match( '/^([a-f0-9]{3}|[a-f0-9]{6})$/i', $hex ) ) :      // check if input string is a valid hex colour code.
			if ( strlen( $hex ) == 3 ) { // three letters code.
				$r = hexdec( substr( $hex, 0, 1 ) . substr( $hex, 0, 1 ) );
				$g = hexdec( substr( $hex, 1, 1 ) . substr( $hex, 1, 1 ) );
				$b = hexdec( substr( $hex, 2, 1 ) . substr( $hex, 2, 1 ) );
			} else { // six letters coode.
				$r = hexdec( substr( $hex, 0, 2 ) );
				$g = hexdec( substr( $hex, 2, 2 ) );
				$b = hexdec( substr( $hex, 4, 2 ) );
			}
			return 'rgba(' . implode( ',', array( $r, $g, $b ) ) . ',' . $opacity . ')';         // returns the rgb values separated by commas, ready for usage in a rgba( rr,gg,bb,aa ) CSS rule
			// return array($r, $g, $b); // alternatively, return the code as an array.
		else :
			return '';  // input string is not a valid hex color code - return a blank value; this can be changed to return a default colour code for example.
		endif;
	}
}
// bsf core.
$bsf_core_version_file = realpath( dirname( __FILE__ ) . '/admin/bsf-core/version.yml' );
if ( is_file( $bsf_core_version_file ) ) {
	global $bsf_core_version, $bsf_core_path;
	$bsf_core_dir = realpath( dirname( __FILE__ ) . '/admin/bsf-core/' );
	$version      = parallax_get_filesystem()->get_contents( $bsf_core_version_file );
	if ( version_compare( $version, (string)$bsf_core_version, '>' ) ) {
		$bsf_core_version = $version;
		$bsf_core_path    = $bsf_core_dir;
	}
}
add_action( 'init', 'bsf_core_load', 999 );
if ( ! function_exists( 'bsf_core_load' ) ) {
	/**
	 * Loads core.
	 *
	 * @access public
	 */
	function bsf_core_load() {
		global $bsf_core_version, $bsf_core_path;
		if ( is_file( realpath( $bsf_core_path . '/index.php' ) ) ) {
			include_once realpath( $bsf_core_path . '/index.php' );
		}
	}
}
/**
 * Get file system
 *
 * @return object File system object.
 */
function parallax_get_filesystem() {
	global $wp_filesystem;

	require_once ABSPATH . '/wp-admin/includes/file.php';

	WP_Filesystem();

	return $wp_filesystem;
}
add_filter( 'ult_get_img_single', 'ult_img_single_init', 10, 3 );

if ( ! function_exists( 'ult_img_single_init' ) ) {
	/**
	 * For the animation in the module
	 *
	 * @param array  $content represts module content.
	 * @param string $data value has been set to epmty.
	 * @param mixed  $size size is set full.
	 * @access public
	 */
	function ult_img_single_init( $content = null, $data = '', $size = 'full' ) {

		$final = '';

		if ( '' != $content && 'null|null' != $content ) {

			// Create an array.
			$main_str = explode( '|', (string) $content );
			$string   = '';
			$main_arr = array();

			$temp_id  = $main_str[0];
			$temp_url = ( isset( $main_str[1] ) ) ? $main_str[1] : 'null';

			if ( ! empty( $main_str ) && is_array( $main_str ) ) {
				foreach ( $main_str as $key => $value ) {
					if ( ! empty( $value ) ) {
						if ( stripos( $value, '^' ) !== false ) {
							$tmvav_array = explode( '^', $value );
							if ( is_array( $tmvav_array ) && ! empty( $tmvav_array ) ) {
								if ( ! empty( $tmvav_array ) ) {
									if ( isset( $tmvav_array[0] ) ) {
										$main_arr[ $tmvav_array[0] ] = ( isset( $tmvav_array[1] ) ) ? $tmvav_array[1] : '';
									}
								}
							}
						} else {
							$main_arr['id']  = $temp_id;
							$main_arr['url'] = $temp_url;
						}
					}
				}
			}

			if ( '' != $data ) {
				switch ( $data ) {
					case 'url':     // First  - Priority for ID.
						if ( ! empty( $main_arr['id'] ) && 'null' != $main_arr['id'] ) {

							$image_url = '';
							// Get image URL, If input is number - e.g. 100x48 / 140x40 / 350x53.
							if ( preg_match( '/^\d/', $size ) === 1 ) {
								$size = explode( 'x', $size );

								// resize image using vc helper function - wpb_resize.
								$img = wpb_resize( $main_arr['id'], null, $size[0], $size[1], true );
								if ( $img ) {
									$image_url = $img['url'];
								}
							} else {

								// Get image URL, If input is string - [thumbnail, medium, large, full].ab-item.
								$has_image = wp_get_attachment_image_src( $main_arr['id'], $size ); // returns an array.
								$image_url = $has_image[0];
							}

							if ( isset( $image_url ) && ! empty( $image_url ) ) {
								$final = $image_url;
							} else {

								// Second - Priority for URL - get {image from url}.
								if ( isset( $main_arr['url'] ) ) {
									$final = ult_get_url( $main_arr['url'] );
								}
							}
						} else {
							// Second - Priority for URL - get {image from url}.
							if ( isset( $main_arr['url'] ) ) {
								$final = ult_get_url( $main_arr['url'] );
							}
						}
						break;
					case 'title':
						$final = isset( $main_arr['title'] ) ? $main_arr['title'] : get_post_meta( $main_arr['id'], '_wp_attachment_image_title', true );
						break;
					case 'caption':
						$final = isset( $main_arr['caption'] ) ? $main_arr['caption'] : get_post_meta( $main_arr['id'], '_wp_attachment_image_caption', true );
						break;
					case 'alt':
						$final = isset( $main_arr['alt'] ) ? $main_arr['alt'] : get_post_meta( $main_arr['id'], '_wp_attachment_image_alt', true );
						break;
					case 'description':
						$final = isset( $main_arr['description'] ) ? $main_arr['description'] : get_post_meta( $main_arr['id'], '_wp_attachment_image_description', true );
						break;
					case 'json':
						$final = wp_json_encode( $main_arr );
						break;

					case 'sizes':
						$img_size = get_image_squere_size( $img_id, $img_size );

						$img   = wpb_getImageBySize(
							array(
								'attach_id'  => $img_id,
								'thumb_size' => $img_size,
								'class'      => 'vc_single_image-img',
							)
						);
						$final = $img;
						break;

					case 'array':
					default:
						$final = $main_arr;
						break;

				}
			}
		}

		return $final;
	}
}

if ( ! function_exists( 'get_image_squere_size' ) ) {
	/**
	 * Get image size.
	 *
	 * @param mixed $img_id image id.
	 * @param mixed $img_size image size.
	 * @access public
	 */
	function get_image_squere_size( $img_id, $img_size ) {
		if ( preg_match_all( '/(\d+)x(\d+)/', $img_size, $sizes ) ) {
			$exact_size = array(
				'width'  => isset( $sizes[1][0] ) ? $sizes[1][0] : '0',
				'height' => isset( $sizes[2][0] ) ? $sizes[2][0] : '0',
			);
		} else {
			$image_downsize = image_downsize( $img_id, $img_size );
			$exact_size     = array(
				'width'  => $image_downsize[1],
				'height' => $image_downsize[2],
			);
		}
		if ( isset( $exact_size['width'] ) && (int) $exact_size['width'] !== (int) $exact_size['height'] ) {
			$img_size = (int) $exact_size['width'] > (int) $exact_size['height']
			? $exact_size['height'] . 'x' . $exact_size['height']
			: $exact_size['width'] . 'x' . $exact_size['width'];
		}

		return $img_size;
	}
}

if ( ! function_exists( 'ult_get_url' ) ) {
	/**
	 * Get image url.
	 *
	 * @param mixed $img image id.
	 * @access public
	 */
	function ult_get_url( $img ) {
		if ( isset( $img ) && ! empty( $img ) ) {
			return $img;
		}
	}
}
if ( ! function_exists( 'rgba_to_hex_ultimate' ) ) {
	/**
	 * Rgba to Hex
	 *
	 * @param mixed $r red.
	 * @param mixed $g green.
	 * @param mixed $b blue.
	 * @access public
	 */
	function rgba_to_hex_ultimate( $r, $g, $b ) {
		$hex  = '#';
		$hex .= str_pad( dechex( $r ), 2, '0', STR_PAD_LEFT );
		$hex .= str_pad( dechex( $g ), 2, '0', STR_PAD_LEFT );
		$hex .= str_pad( dechex( $b ), 2, '0', STR_PAD_LEFT );
		return $hex;
	}
}
